/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.body;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.util.Objects;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.MimeType;
import net.dongliu.cute.http.body.AbstractBody;
import net.dongliu.cute.http.json.JsonMarshaller;

class JsonBody<T>
extends AbstractBody<T> {
    private final JsonMarshaller jsonMarshaller;

    protected JsonBody(T body, Charset charset, JsonMarshaller jsonMarshaller) {
        super(body, ContentType.of(MimeType.JSON, Objects.requireNonNull(charset)));
        this.jsonMarshaller = Objects.requireNonNull(jsonMarshaller);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public HttpRequest.BodyPublisher asBodyPublisher() {
        try {
            Charset charset = this.contentType().charset().orElseThrow();
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                HttpRequest.BodyPublisher bodyPublisher;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, charset);){
                    this.jsonMarshaller.marshal(this.body(), writer);
                    bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(bos.toByteArray());
                }
                return bodyPublisher;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

