/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.body;

import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.MimeType;
import net.dongliu.cute.http.Param;
import net.dongliu.cute.http.body.AbstractBody;
import net.dongliu.cute.http.body.InputSuppliers;
import net.dongliu.cute.http.internal.UrlUtils;

class FormBody
extends AbstractBody<List<Param>> {
    FormBody(List<Param> body, Charset charset) {
        super(body, ContentType.of(MimeType.WWW_FORM_ENCODED, charset));
    }

    @Override
    public HttpRequest.BodyPublisher asBodyPublisher() {
        Charset charset = this.contentType().charset().orElse(StandardCharsets.UTF_8);
        String content = UrlUtils.encodeForms((Collection)this.body(), charset);
        return HttpRequest.BodyPublishers.ofInputStream(InputSuppliers.of(content, charset));
    }
}

