/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.body;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dongliu.commons.collection.Collections2;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.MimeType;
import net.dongliu.cute.http.Param;
import net.dongliu.cute.http.body.BinaryBody;
import net.dongliu.cute.http.body.Body;
import net.dongliu.cute.http.body.FileBody;
import net.dongliu.cute.http.body.FormBody;
import net.dongliu.cute.http.body.InputStreamBody;
import net.dongliu.cute.http.body.InputSupplier;
import net.dongliu.cute.http.body.JsonBody;
import net.dongliu.cute.http.body.MultiPartBody;
import net.dongliu.cute.http.body.Part;
import net.dongliu.cute.http.body.StringBody;
import net.dongliu.cute.http.json.JsonMarshaller;

public class Bodies {
    public static Body<String> plainText(String value, Charset charset) {
        return Bodies.of(value, MimeType.TEXT_PLAIN, charset);
    }

    public static Body<byte[]> octetStream(byte[] value) {
        return Bodies.of(value, MimeType.OCTET_STREAM);
    }

    public static Body<InputSupplier> octetStream(InputSupplier inputSupplier) {
        return Bodies.of(inputSupplier, MimeType.OCTET_STREAM);
    }

    public static Body<Path> octetStream(Path path) {
        return Bodies.of(path, MimeType.OCTET_STREAM);
    }

    public static Body<String> plainText(String value) {
        return Bodies.plainText(value, StandardCharsets.UTF_8);
    }

    public static Body<List<Param>> wwwForm(Collection<? extends Param> params, Charset charset) {
        return new FormBody(List.copyOf(Objects.requireNonNull(params)), charset);
    }

    public static Body<List<Param>> wwwForm(Collection<? extends Param> params) {
        return Bodies.wwwForm(params, StandardCharsets.UTF_8);
    }

    public static Body<List<Param>> wwwForm(Map<String, String> map, Charset charset) {
        List params = Collections2.convertToList(map.entrySet(), e -> Param.of((String)e.getKey(), (String)e.getValue()));
        return new FormBody(params, charset);
    }

    public static Body<List<Param>> wwwForm(Map<String, String> params) {
        return Bodies.wwwForm(params, StandardCharsets.UTF_8);
    }

    public static Body<List<Param>> wwwForm(Param ... params) {
        Objects.requireNonNull(params);
        return new FormBody(List.of(params), StandardCharsets.UTF_8);
    }

    public static Body<List<Part<?>>> multiPart(List<? extends Part<?>> parts) {
        return new MultiPartBody(List.copyOf((Collection)Objects.requireNonNull(parts)));
    }

    public static Body<List<Part<?>>> multiPart(Part<?> ... parts) {
        Objects.requireNonNull(parts);
        return new MultiPartBody(List.of(parts));
    }

    public static <T> Body<T> json(T value, Charset charset, JsonMarshaller jsonMarshaller) {
        return new JsonBody<T>(value, charset, jsonMarshaller);
    }

    public static <T> Body<T> json(T value, JsonMarshaller jsonMarshaller) {
        return new JsonBody<T>(value, StandardCharsets.UTF_8, jsonMarshaller);
    }

    public static Body<byte[]> of(byte[] value, MimeType mimeType) {
        return new BinaryBody(Objects.requireNonNull(value), ContentType.of(mimeType));
    }

    public static Body<byte[]> of(byte[] value, MimeType mimeType, Charset charset) {
        return new BinaryBody(Objects.requireNonNull(value), ContentType.of(mimeType, charset));
    }

    public static Body<String> of(String value, MimeType mimeType) {
        return Bodies.of(value, mimeType, StandardCharsets.UTF_8);
    }

    public static Body<String> of(String value, MimeType mimeType, Charset charset) {
        return new StringBody(Objects.requireNonNull(value), ContentType.of(mimeType, charset));
    }

    public static Body<InputSupplier> of(InputSupplier supplier, MimeType mimeType) {
        return new InputStreamBody(Objects.requireNonNull(supplier), ContentType.of(mimeType));
    }

    public static Body<InputSupplier> of(InputSupplier supplier, MimeType mimeType, Charset charset) {
        return new InputStreamBody(Objects.requireNonNull(supplier), ContentType.of(mimeType, charset));
    }

    public static Body<Path> of(Path path, MimeType mimeType) {
        return new FileBody(Objects.requireNonNull(path), ContentType.of(mimeType));
    }

    public static Body<Path> of(Path path, MimeType mimeType, Charset charset) {
        return new FileBody(Objects.requireNonNull(path), ContentType.of(mimeType, charset));
    }
}

