/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dongliu.commons.Lazy;
import net.dongliu.cute.http.Cookie;

public class Cookies {
    private final List<Cookie> cookies;
    private final Lazy<Map<String, Cookie>> map;

    Cookies(List<Cookie> cookies) {
        this.cookies = List.copyOf(cookies);
        this.map = Lazy.of(() -> Cookies.toMap(cookies));
    }

    private static Map<String, Cookie> toMap(List<Cookie> cookies) {
        HashMap<String, Cookie> map = new HashMap<String, Cookie>();
        for (Cookie cookie : cookies) {
            map.put(cookie.name(), cookie);
        }
        return map;
    }

    public Optional<Cookie> getCookie(String name) {
        Cookie c = (Cookie)((Map)this.map.get()).get(name);
        return Optional.ofNullable(c);
    }

    public List<Cookie> allCookies() {
        return this.cookies;
    }
}

