/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import net.dongliu.cute.http.MimeType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ContentType {
    private final MimeType mimeType;
    private final @Nullable Charset charset;
    private final String boundary;

    private ContentType(MimeType mimeType, @Nullable Charset charset, String boundary) {
        this.mimeType = mimeType;
        this.charset = charset;
        this.boundary = boundary;
    }

    public static ContentType of(MimeType mimeType) {
        Objects.requireNonNull(mimeType);
        return new ContentType(mimeType, null, "");
    }

    public static ContentType of(MimeType mimeType, Charset charset) {
        Objects.requireNonNull(mimeType);
        Objects.requireNonNull(charset);
        return new ContentType(mimeType, charset, "");
    }

    public static ContentType multiPart(String boundary) {
        if (Objects.requireNonNull(boundary).isEmpty()) {
            throw new IllegalArgumentException("boundary is empty");
        }
        return new ContentType(MimeType.MULTI_PART, null, boundary);
    }

    public static Optional<ContentType> safeParse(String contentTypeStr) {
        Objects.requireNonNull(contentTypeStr);
        if (contentTypeStr.isEmpty()) {
            return Optional.empty();
        }
        String[] splits = contentTypeStr.split("; ");
        if (splits.length > 2) {
            return Optional.empty();
        }
        Optional<MimeType> mimeTypeOptional = MimeType.safeParse(splits[0]);
        if (mimeTypeOptional.isEmpty()) {
            return Optional.empty();
        }
        MimeType mimeType = mimeTypeOptional.get();
        if (splits.length == 2) {
            String str = splits[1].trim();
            int idx = str.indexOf(61);
            if (idx == -1) {
                return Optional.empty();
            }
            String name = str.substring(0, idx);
            String value = str.substring(idx + 1);
            switch (name) {
                case "charset": {
                    return Optional.of(new ContentType(mimeType, Charset.forName(value), ""));
                }
                case "boundary": {
                    return Optional.of(new ContentType(mimeType, null, value));
                }
            }
            return Optional.empty();
        }
        return Optional.of(ContentType.of(mimeType));
    }

    public MimeType mimeType() {
        return this.mimeType;
    }

    public Optional<Charset> charset() {
        return Optional.ofNullable(this.charset);
    }

    public String boundary() {
        return this.boundary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentType that = (ContentType)o;
        return Objects.equals(this.mimeType, that.mimeType) && Objects.equals(this.charset, that.charset) && Objects.equals(this.boundary, that.boundary);
    }

    public int hashCode() {
        return Objects.hash(this.mimeType, this.charset, this.boundary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.mimeType.toString());
        if (this.charset != null) {
            sb.append("; charset=").append(this.charset.name().toLowerCase());
        }
        if (!this.boundary.isEmpty()) {
            sb.append("; boundary=").append(this.boundary);
        }
        return sb.toString();
    }
}

