/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dongliu.commons.collection.Collections2;
import net.dongliu.cute.http.Cookie;
import net.dongliu.cute.http.Header;
import net.dongliu.cute.http.Method;
import net.dongliu.cute.http.Param;
import net.dongliu.cute.http.Request;
import net.dongliu.cute.http.body.Bodies;
import net.dongliu.cute.http.body.Body;
import net.dongliu.cute.http.exception.JsonMarshallerNotFoundException;
import net.dongliu.cute.http.internal.Asserts;
import net.dongliu.cute.http.json.JsonMarshaller;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractRequestBuilder<T extends AbstractRequestBuilder<T>> {
    private final @Nullable JsonMarshaller jsonMarshaller;
    final Method method;
    final URL url;
    List<Header> headers = List.of();
    List<Cookie> cookies = List.of();
    List<Param> params = List.of();
    Charset paramCharset = StandardCharsets.UTF_8;
    @Nullable Body<?> body = null;
    @Nullable PasswordAuthentication basicAuth = null;
    Duration timeout = Duration.ofSeconds(10L);
    @Nullable String userAgent = null;
    @Nullable String referer = null;
    boolean acceptCompressed = true;

    AbstractRequestBuilder(Method method, URL url, @Nullable JsonMarshaller jsonMarshaller) {
        this.method = Objects.requireNonNull(method);
        this.url = Objects.requireNonNull(url);
        this.jsonMarshaller = jsonMarshaller;
    }

    public T timeout(Duration timeout) {
        this.timeout = Asserts.checkTimeout(timeout);
        return this.self();
    }

    public T userAgent(String userAgent) {
        this.userAgent = Objects.requireNonNull(userAgent);
        return this.self();
    }

    public T referer(String referer) {
        this.referer = Objects.requireNonNull(referer);
        return this.self();
    }

    public T headers(Collection<? extends Header> headers) {
        Objects.requireNonNull(headers);
        this.headers = List.copyOf(headers);
        return this.self();
    }

    public final T headers(Header ... headers) {
        this.headers(List.of(headers));
        return this.self();
    }

    public final T headers(Map<String, String> map) {
        this.headers = Collections2.convertToList(map.entrySet(), e -> Header.of((String)e.getKey(), (String)e.getValue()));
        return this.self();
    }

    public T cookies(Collection<? extends Cookie> cookies) {
        Objects.requireNonNull(cookies);
        this.cookies = List.copyOf(cookies);
        return this.self();
    }

    public final T cookies(Cookie ... cookies) {
        this.cookies(List.of(cookies));
        return this.self();
    }

    public final T cookies(Map<String, String> map) {
        this.cookies = Collections2.convertToList(map.entrySet(), e -> Cookie.of((String)e.getKey(), (String)e.getValue()));
        return this.self();
    }

    public T params(Collection<? extends Param> params) {
        Objects.requireNonNull(params);
        this.params = List.copyOf(params);
        return this.self();
    }

    public T params(Collection<? extends Param> params, Charset charset) {
        this.params = List.copyOf(Objects.requireNonNull(params));
        this.paramCharset = charset;
        return this.self();
    }

    public final T params(Param ... params) {
        this.params = List.of(params);
        return this.self();
    }

    public final T params(Map<String, String> map) {
        this.params = Collections2.convertToList(map.entrySet(), e -> Param.of((String)e.getKey(), (String)e.getValue()));
        return this.self();
    }

    public final T params(Map<String, String> map, Charset charset) {
        this.params = Collections2.convertToList(map.entrySet(), e -> Param.of((String)e.getKey(), (String)e.getValue()));
        this.paramCharset = charset;
        return this.self();
    }

    public T body(Body<?> body) {
        this.body = Objects.requireNonNull(body);
        return this.self();
    }

    public T jsonBody(@Nullable Object body, Charset charset) {
        Objects.requireNonNull(charset);
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        this.body = Bodies.json(body, charset, this.jsonMarshaller);
        return this.self();
    }

    public T jsonBody(@Nullable Object body) {
        return this.jsonBody(body, StandardCharsets.UTF_8);
    }

    public T acceptCompressed(boolean acceptCompressed) {
        this.acceptCompressed = acceptCompressed;
        return this.self();
    }

    public T basicAuth(String user, char[] password) {
        return this.basicAuth(new PasswordAuthentication(Objects.requireNonNull(user), Objects.requireNonNull(password)));
    }

    public T basicAuth(PasswordAuthentication basicAuth) {
        this.basicAuth = Objects.requireNonNull(basicAuth);
        return this.self();
    }

    public Request build() {
        return new Request(this);
    }

    protected abstract T self();
}

