package net.dongliu.cute.http.json;

import net.dongliu.commons.Lazy;

import java.util.Optional;
import java.util.ServiceLoader;

/**
 * Utils for get JsonMarshaller
 */
public class JsonMarshallers {

    /**
     * Get JsonMarshaller instance by SPI.
     */
    public static Optional<JsonMarshaller> getJsonMarshaller() {
        return jsonMarshaller.get();
    }

    private static final Lazy<Optional<JsonMarshaller>> jsonMarshaller = Lazy.of(JsonMarshallers::loadJsonMarshaller);

    private static Optional<JsonMarshaller> loadJsonMarshaller() {
        var iterator = ServiceLoader.load(JsonMarshaller.class).iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        var marshaller = iterator.next();
        if (iterator.hasNext()) {
            System.err.println("CuteHttp: multi json marshaller implementation found, ignore others. ");
        }
        return Optional.of(marshaller);
    }
}
