package net.dongliu.cute.http.json;

import org.checkerframework.checker.nullness.qual.Nullable;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;

/**
 * Interface for marshalling to and unmarshalling from json.
 */
public interface JsonMarshaller {

    /**
     * Marshal value to json, and write to output stream.
     * The writer is leaved unclosed when marshal finished or exception occurred.
     */
    void marshal(@Nullable Object value, Writer writer) throws IOException;

    /**
     * Unmarshal json from input stream, by Type.
     * The reader is leaved unclosed when unmarshal finished or exception occurred.
     */
    <T> @Nullable T unmarshal(Reader reader, Type type) throws IOException;
}
