package net.dongliu.cute.http.body;

import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.MimeType;
import net.dongliu.cute.http.json.JsonMarshaller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;
import java.nio.charset.Charset;

import static java.util.Objects.requireNonNull;

/**
 * Json body
 *
 * @param <T>
 */
class JsonBody<T> extends AbstractBody<T> {
    private final JsonMarshaller jsonMarshaller;

    /**
     * Construct a new Body.
     *
     * @param body           the body data
     * @param charset        the charset to encode body
     * @param jsonMarshaller the jsonMarshaller
     */
    protected JsonBody(T body, Charset charset, JsonMarshaller jsonMarshaller) {
        super(body, ContentType.of(MimeType.JSON, requireNonNull(charset)));
        this.jsonMarshaller = requireNonNull(jsonMarshaller);
    }

    @Override
    public BodyPublisher asBodyPublisher() {
        try {
            var charset = contentType().charset().orElseThrow();
            try (var bos = new ByteArrayOutputStream();
                 var writer = new OutputStreamWriter(bos, charset)) {
                jsonMarshaller.marshal(body(), writer);
                return BodyPublishers.ofByteArray(bos.toByteArray());
            }
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}
