package net.dongliu.cute.http;

import java.io.Closeable;
import java.io.IOException;

/**
 * Handle response in blocking way.
 *
 * @param <B> the original Response body type, could be InputStream or Reader
 * @param <T> the converted response body type.
 */
@FunctionalInterface
public interface ResponseHandler<B extends Closeable, T> {
    /**
     * Handler response body with all info, return a transformed response body.
     *
     * @return the value body convert to
     */
    T handle(ResponseInfo info, B body) throws IOException;
}
