package net.dongliu.cute.http;

import java.net.URL;

/**
 * This class carries raw Http response data.
 *
 * @param <T> the body type, could be InputStream, or Reader, or Publisher
 */
class RawResponse<T> {

    private final Method method;
    private final URL url;
    private final ResponseInfo info;
    private final T body;

    RawResponse(Method method, URL url, ResponseInfo info, T body) {
        this.method = method;
        this.url = url;
        this.info = info;
        this.body = body;
    }

    public Method method() {
        return method;
    }

    public URL url() {
        return url;
    }

    public ResponseInfo info() {
        return info;
    }

    public T body() {
        return body;
    }

}
