/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.HTTPCookie;
import net.dongliu.cute.http.HTTPHeader;
import net.dongliu.cute.http.HTTPRequest;
import net.dongliu.cute.http.body.Body;
import net.dongliu.cute.http.exception.RequestsException;
import net.dongliu.cute.http.internal.UrlUtils;

public class RequestUtils {
    private static final String COMPRESS_ENCODINGS = "gzip, deflate";

    public static HttpRequest toHttpRequest(HTTPRequest request) {
        URI uri;
        Optional<Body<?>> body = request.body();
        HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder();
        HttpRequest.BodyPublisher bodyPublisher = body.map(Body::asBodyPublisher).orElseGet(HttpRequest.BodyPublishers::noBody);
        switch (request.method()) {
            case GET: {
                httpRequestBuilder.GET();
                break;
            }
            case DELETE: {
                httpRequestBuilder.DELETE();
                break;
            }
            default: {
                httpRequestBuilder.method(request.method().name(), bodyPublisher);
            }
        }
        URL url = UrlUtils.joinUrl(request.url(), request.params(), request.paramCharset());
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RequestsException(e);
        }
        httpRequestBuilder.uri(uri);
        httpRequestBuilder.expectContinue(false);
        body.ifPresent(b -> {
            ContentType contentType = b.contentType();
            httpRequestBuilder.setHeader("Content-Type", contentType.toString());
        });
        httpRequestBuilder.timeout(request.timeout());
        request.userAgent().ifPresent(ua -> httpRequestBuilder.setHeader("User-Agent", (String)ua));
        request.referer().ifPresent(referer -> httpRequestBuilder.setHeader("Referer", (String)referer));
        request.basicAuth().ifPresent(ba -> {
            String authStr = ba.getUserName() + ":" + new String(ba.getPassword());
            String auth = "Basic " + Base64.getEncoder().encodeToString(authStr.getBytes(StandardCharsets.UTF_8));
            httpRequestBuilder.setHeader("Authorization", auth);
        });
        if (request.acceptCompress()) {
            httpRequestBuilder.setHeader("Accept-Encoding", COMPRESS_ENCODINGS);
        }
        if (!request.cookies().isEmpty()) {
            for (HTTPCookie cookie : request.cookies()) {
                httpRequestBuilder.header("Cookie", cookie.name() + "=" + cookie.value());
            }
        }
        for (HTTPHeader header : request.headers()) {
            httpRequestBuilder.setHeader(header.name(), String.valueOf(header.value()));
        }
        httpRequestBuilder.timeout(request.timeout());
        return httpRequestBuilder.build();
    }
}

