/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.body;

import java.nio.file.Path;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.MimeType;
import net.dongliu.cute.http.body.FileTypes;
import net.dongliu.cute.http.body.InputSupplier;
import net.dongliu.cute.http.body.InputSuppliers;
import net.dongliu.cute.http.body.Part;

public class Parts {
    public static Part<InputSupplier> file(String name, Path path, MimeType mimeType) {
        return new Part.FilePart(name, path.toString(), InputSuppliers.of(path), ContentType.of(mimeType));
    }

    public static Part<InputSupplier> file(String name, Path path) {
        MimeType mimeType = FileTypes.detectFileType(path).orElse(MimeType.OCTET_STREAM);
        return Parts.file(name, path, mimeType);
    }

    public static Part<InputSupplier> file(String name, String filename, InputSupplier supplier, MimeType mimeType) {
        return new Part.FilePart(name, filename, supplier, ContentType.of(mimeType));
    }

    public static Part<InputSupplier> file(String name, String filename, byte[] bytes, MimeType mimeType) {
        return new Part.FilePart(name, filename, InputSuppliers.of(bytes), ContentType.of(mimeType));
    }

    public static Part<String> text(String name, String value) {
        return new Part.TextPart(name, value);
    }
}

