/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;

public class ProxySelectors {
    private static final List<Proxy> DIRECT_PROXIES = List.of(Proxy.NO_PROXY);

    public static ProxySelector staticSelector(Proxy proxy) {
        return new StaticProxySelector(List.of(proxy));
    }

    static class StaticProxySelector
    extends ProxySelector {
        private final List<Proxy> list;

        StaticProxySelector(List<Proxy> list) {
            this.list = list;
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException e) {
        }

        @Override
        public synchronized List<Proxy> select(URI uri) {
            String scheme = uri.getScheme().toLowerCase();
            if (scheme.equals("http") || scheme.equals("https")) {
                return this.list;
            }
            return DIRECT_PROXIES;
        }
    }
}

