/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.util.Objects;
import java.util.Optional;

public class MimeType {
    private final String type;
    private final String subType;
    public static final MimeType TEXT_PLAIN = MimeType.of("text", "plain");
    public static final MimeType HTML = MimeType.of("text", "html");
    public static final MimeType CSS = MimeType.of("text", "css");
    public static final MimeType JSON = MimeType.of("application", "json");
    public static final MimeType XHTML = MimeType.of("application", "xhtml+xml");
    public static final MimeType XML = MimeType.of("application", "xml");
    public static final MimeType OCTET_STREAM = MimeType.of("application", "octet-stream");
    public static final MimeType MULTI_PART = MimeType.of("multipart", "form-data");
    public static final MimeType WWW_FORM_ENCODED = MimeType.of("application", "x-www-form-urlencoded");

    private MimeType(String type, String subType) {
        this.type = type;
        this.subType = subType;
    }

    public static MimeType of(String type, String subType) {
        return new MimeType(Objects.requireNonNull(type), Objects.requireNonNull(subType));
    }

    public static Optional<MimeType> safeParse(String mimeType) {
        Objects.requireNonNull(mimeType);
        if (mimeType.isEmpty()) {
            return Optional.empty();
        }
        int idx = mimeType.indexOf("/");
        if (idx == -1) {
            return Optional.empty();
        }
        String type = mimeType.substring(0, idx);
        String subType = mimeType.substring(idx + 1);
        if (type.isEmpty() || subType.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MimeType(type, subType));
    }

    public String type() {
        return this.type;
    }

    public String subType() {
        return this.subType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeType mimeType = (MimeType)o;
        return Objects.equals(this.type, mimeType.type) && Objects.equals(this.subType, mimeType.subType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subType);
    }

    public String toString() {
        return this.type + "/" + this.subType;
    }
}

