/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.net.URL;
import java.util.Objects;
import java.util.function.Function;
import net.dongliu.cute.http.HTTPCookies;
import net.dongliu.cute.http.HTTPHeaders;

public class HTTPResponse<T> {
    private final URL url;
    private final int statusCode;
    private final HTTPHeaders headers;
    private final T body;

    HTTPResponse(URL url, int statusCode, HTTPHeaders headers, T body) {
        this.url = Objects.requireNonNull(url);
        this.statusCode = statusCode;
        this.headers = Objects.requireNonNull(headers);
        this.body = body;
    }

    public URL url() {
        return this.url;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public HTTPCookies cookies() {
        return this.headers.cookies();
    }

    public HTTPHeaders headers() {
        return this.headers;
    }

    public T body() {
        return this.body;
    }

    public <R> HTTPResponse<R> transform(Function<T, R> transformer) {
        R body = transformer.apply(this.body);
        return new HTTPResponse<R>(this.url, this.statusCode, this.headers, body);
    }
}

