/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import net.dongliu.cute.http.AbstractHTTPRequestBuilder;
import net.dongliu.cute.http.AsyncHTTPResponseContext;
import net.dongliu.cute.http.HTTPClient;
import net.dongliu.cute.http.HTTPHeaders;
import net.dongliu.cute.http.HTTPMethod;
import net.dongliu.cute.http.HTTPRequest;
import net.dongliu.cute.http.HTTPResponseContext;
import net.dongliu.cute.http.RawHTTPResponse;
import net.dongliu.cute.http.ResponseInfo;
import net.dongliu.cute.http.exception.RequestsException;
import net.dongliu.cute.http.internal.RequestUtils;

public class HTTPRequestContext
extends AbstractHTTPRequestBuilder<HTTPRequestContext> {
    private final HTTPClient client;

    HTTPRequestContext(HTTPClient client, HTTPMethod method, URL url) {
        super(method, url, client.jsonMarshaller().orElse(null));
        this.client = client;
    }

    public HTTPResponseContext send() {
        URL url;
        HttpResponse<InputStream> response;
        HTTPRequest request = this.build();
        HttpRequest httpRequest = RequestUtils.toHttpRequest(request);
        try {
            response = this.client.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RequestsException("HTTP Request has been interrupted");
        }
        int status = response.statusCode();
        HttpHeaders httpHeaders = response.headers();
        HTTPHeaders headers = HTTPHeaders.ofHttpHeaders(httpHeaders);
        try {
            url = response.uri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RequestsException(e);
        }
        ResponseInfo responseInfo = new ResponseInfo(status, headers);
        RawHTTPResponse<InputStream> resp = new RawHTTPResponse<InputStream>(this.method, url, responseInfo, response.body());
        return new HTTPResponseContext(resp, this.client.jsonMarshaller().orElse(null));
    }

    public AsyncHTTPResponseContext sendAsync() {
        HTTPRequest request = this.build();
        HttpRequest httpRequest = RequestUtils.toHttpRequest(request);
        CompletionStage responseFuture = this.client.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofPublisher()).thenApply(r -> {
            URL url;
            HTTPHeaders headers = HTTPHeaders.ofHttpHeaders(r.headers());
            try {
                url = r.uri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RequestsException(e);
            }
            ResponseInfo responseInfo = new ResponseInfo(r.statusCode(), headers);
            return new RawHTTPResponse<Flow.Publisher>(this.method, url, responseInfo, (Flow.Publisher)r.body());
        });
        return new AsyncHTTPResponseContext((CompletableFuture<RawHTTPResponse<Flow.Publisher<List<ByteBuffer>>>>)responseFuture, this.client.jsonMarshaller().orElse(null));
    }

    @Override
    protected HTTPRequestContext self() {
        return this;
    }
}

