/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.dongliu.cute.http.AbstractHTTPRequestBuilder;
import net.dongliu.cute.http.HTTPCookie;
import net.dongliu.cute.http.HTTPHeader;
import net.dongliu.cute.http.HTTPMethod;
import net.dongliu.cute.http.Param;
import net.dongliu.cute.http.body.Body;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HTTPRequest {
    private final HTTPMethod method;
    private final List<HTTPHeader> headers;
    private final List<HTTPCookie> cookies;
    private final List<Param> params;
    private final Charset paramCharset;
    private final @Nullable Body<?> body;
    private final boolean acceptCompress;
    private final @Nullable PasswordAuthentication basicAuth;
    private final URL url;
    private final @Nullable String userAgent;
    private final @Nullable String referer;
    private final Duration timeout;

    HTTPRequest(AbstractHTTPRequestBuilder<?> builder) {
        this.method = builder.method;
        this.url = builder.url;
        this.headers = builder.headers;
        this.cookies = builder.cookies;
        this.userAgent = builder.userAgent;
        this.referer = builder.referer;
        this.paramCharset = builder.paramCharset;
        this.body = builder.body;
        this.acceptCompress = builder.acceptCompress;
        this.basicAuth = builder.basicAuth;
        this.params = builder.params;
        this.timeout = builder.timeout;
    }

    public HTTPMethod method() {
        return this.method;
    }

    public List<HTTPHeader> headers() {
        return this.headers;
    }

    public List<HTTPCookie> cookies() {
        return this.cookies;
    }

    public Optional<String> userAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    public Optional<String> referer() {
        return Optional.ofNullable(this.referer);
    }

    public Charset paramCharset() {
        return this.paramCharset;
    }

    public Optional<Body<?>> body() {
        return Optional.ofNullable(this.body);
    }

    public boolean acceptCompress() {
        return this.acceptCompress;
    }

    public Optional<PasswordAuthentication> basicAuth() {
        return Optional.ofNullable(this.basicAuth);
    }

    public URL url() {
        return this.url;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public List<Param> params() {
        return this.params;
    }
}

