/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.time.Instant;
import java.util.Objects;
import java.util.OptionalLong;
import net.dongliu.cute.http.NameValue;

public class HTTPCookie
implements NameValue {
    private final String name;
    private final String value;
    private final String domain;
    private final String path;
    private final OptionalLong maxAge;
    private final boolean secure;
    private final boolean httpOnly;
    private final Instant createTime;

    protected HTTPCookie(String name, String value, String domain, String path, OptionalLong maxAge, boolean secure, boolean httpOnly, Instant createTime) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.maxAge = maxAge;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.createTime = createTime;
    }

    public static HTTPCookie of(String name, String value) {
        return new HTTPCookie(Objects.requireNonNull(name), Objects.requireNonNull(value), "", "", OptionalLong.empty(), false, false, Instant.EPOCH);
    }

    public String domain() {
        return this.domain;
    }

    public String path() {
        return this.path;
    }

    public OptionalLong maxAge() {
        return this.maxAge;
    }

    public boolean secure() {
        return this.secure;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public Instant createTime() {
        return this.createTime;
    }

    @Override
    public boolean nameCaseSensitive() {
        return true;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPCookie that = (HTTPCookie)o;
        return this.secure == that.secure && this.httpOnly == that.httpOnly && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.domain, that.domain) && Objects.equals(this.path, that.path) && Objects.equals(this.maxAge, that.maxAge) && Objects.equals(this.createTime, that.createTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value, this.domain, this.path, this.maxAge, this.secure, this.httpOnly, this.createTime);
    }

    @Override
    public String toString() {
        return "Cookie{name='" + this.name + "', value='" + this.value + "', domain='" + this.domain + "', path='" + this.path + "', maxAge=" + this.maxAge + ", secure=" + this.secure + ", httpOnly=" + this.httpOnly + ", createTime=" + this.createTime + "}";
    }
}

