/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.Proxy;
import java.net.ProxySelector;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import net.dongliu.cute.http.HTTPClient;
import net.dongliu.cute.http.ProxySelectors;
import net.dongliu.cute.http.internal.Asserts;
import net.dongliu.cute.http.internal.HonoredCookieManager;
import net.dongliu.cute.http.json.JsonMarshaller;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HTTPClientBuilder {
    @Nullable String name;
    @Nullable ProxySelector proxySelector = null;
    boolean useHttp2 = true;
    boolean verifyCert = true;
    boolean followRedirect = true;
    @Nullable Authenticator authenticator = null;
    CookieHandler cookieHandler = new HonoredCookieManager();
    @Nullable Executor executor = null;
    @Nullable KeyStore keyStore = null;
    Duration connectTimeout = Duration.ofSeconds(5L);
    Duration timeout = Duration.ofSeconds(10L);
    @Nullable String userAgent = null;
    boolean acceptCompress = true;
    @Nullable JsonMarshaller jsonMarshaller;

    public HTTPClient build() {
        return new HTTPClient(this);
    }

    public HTTPClientBuilder name(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    public HTTPClientBuilder proxy(ProxySelector proxySelector) {
        this.proxySelector = Objects.requireNonNull(proxySelector);
        return this;
    }

    public HTTPClientBuilder proxy(Proxy proxy) {
        Objects.requireNonNull(proxy);
        this.proxySelector = Objects.requireNonNull(ProxySelectors.staticSelector(proxy));
        return this;
    }

    public HTTPClientBuilder useHttp2(boolean useHttp2) {
        this.useHttp2 = useHttp2;
        return this;
    }

    public HTTPClientBuilder verifyCert(boolean verify) {
        this.verifyCert = verify;
        return this;
    }

    public HTTPClientBuilder followRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this;
    }

    public HTTPClientBuilder connectTimeout(Duration timeout) {
        this.connectTimeout = Asserts.checkTimeout(timeout);
        return this;
    }

    public HTTPClientBuilder timeout(Duration timeout) {
        this.timeout = Asserts.checkTimeout(timeout);
        return this;
    }

    public HTTPClientBuilder userAgent(String userAgent) {
        this.userAgent = Objects.requireNonNull(userAgent);
        return this;
    }

    public HTTPClientBuilder acceptCompress(boolean acceptCompress) {
        this.acceptCompress = acceptCompress;
        return this;
    }

    public HTTPClientBuilder authenticator(Authenticator authenticator) {
        this.authenticator = Objects.requireNonNull(authenticator);
        return this;
    }

    public HTTPClientBuilder cookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = Objects.requireNonNull(cookieHandler);
        return this;
    }

    public HTTPClientBuilder keyStore(KeyStore keyStore) {
        this.keyStore = Objects.requireNonNull(keyStore);
        return this;
    }

    public HTTPClientBuilder executor(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
        return this;
    }

    public HTTPClientBuilder jsonMarshaller(JsonMarshaller jsonMarshaller) {
        this.jsonMarshaller = Objects.requireNonNull(jsonMarshaller);
        return this;
    }
}

