/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URL;
import java.net.http.HttpClient;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import net.dongliu.commons.Lazy;
import net.dongliu.commons.Objects2;
import net.dongliu.commons.concurrent.ThreadFactories;
import net.dongliu.cute.http.HTTPClientBuilder;
import net.dongliu.cute.http.HTTPMethod;
import net.dongliu.cute.http.HTTPRequestContext;
import net.dongliu.cute.http.exception.RequestsException;
import net.dongliu.cute.http.internal.SSLContextFactories;
import net.dongliu.cute.http.json.JsonMarshaller;
import net.dongliu.cute.http.json.JsonMarshallers;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HTTPClient {
    private final String name;
    private final @Nullable ProxySelector proxySelector;
    private final boolean useHttp2;
    private final boolean verifyCert;
    private final boolean followRedirect;
    private final @Nullable Authenticator authenticator;
    private final CookieHandler cookieHandler;
    private final Executor executor;
    private final @Nullable KeyStore keyStore;
    private final Duration connectTimeout;
    private final Duration timeout;
    private final String userAgent;
    private final boolean acceptCompress;
    private final @Nullable JsonMarshaller jsonMarshaller;
    final HttpClient httpClient;
    private static final AtomicLong seq = new AtomicLong(0L);
    private static final Lazy<HTTPClient> defaultClient = Lazy.of(() -> new HTTPClientBuilder().build());

    HTTPClient(HTTPClientBuilder builder) {
        this.name = (String)Objects2.elvis((Object)builder.name, () -> "HttpClient-" + seq.getAndIncrement());
        this.proxySelector = builder.proxySelector;
        this.useHttp2 = builder.useHttp2;
        this.verifyCert = builder.verifyCert;
        this.followRedirect = builder.followRedirect;
        this.timeout = builder.timeout;
        this.userAgent = (String)Objects2.elvis((Object)builder.userAgent, () -> "HttpClient, Java " + System.getProperty("java.version"));
        this.acceptCompress = builder.acceptCompress;
        this.authenticator = builder.authenticator;
        this.cookieHandler = builder.cookieHandler;
        this.keyStore = builder.keyStore;
        this.connectTimeout = builder.connectTimeout;
        this.jsonMarshaller = Optional.ofNullable(builder.jsonMarshaller).or(JsonMarshallers::getJsonMarshaller).orElse(null);
        this.executor = (Executor)Objects2.elvis((Object)builder.executor, () -> Executors.newCachedThreadPool(ThreadFactories.newDaemonThreadFactory((String)this.name)));
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (!this.verifyCert) {
            httpClientBuilder.sslContext(SSLContextFactories.getTrustAllSSLContext());
        } else if (this.keyStore != null) {
            httpClientBuilder.sslContext(SSLContextFactories.getCustomTrustSSLContext(this.keyStore));
        }
        httpClientBuilder.executor(this.executor);
        httpClientBuilder.version(this.useHttp2 ? HttpClient.Version.HTTP_2 : HttpClient.Version.HTTP_1_1).followRedirects(this.followRedirect ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
        if (this.proxySelector != null) {
            httpClientBuilder.proxy(this.proxySelector);
        }
        if (this.authenticator != null) {
            httpClientBuilder.authenticator(this.authenticator);
        }
        httpClientBuilder.cookieHandler(this.cookieHandler);
        httpClientBuilder.connectTimeout(this.connectTimeout);
        this.httpClient = httpClientBuilder.build();
    }

    public static HTTPClientBuilder builder() {
        return new HTTPClientBuilder();
    }

    public static HTTPClient defaultClient() {
        return (HTTPClient)defaultClient.get();
    }

    public HTTPRequestContext get(URL url) {
        return this.newRequest(HTTPMethod.GET, url);
    }

    public HTTPRequestContext post(URL url) {
        return this.newRequest(HTTPMethod.POST, url);
    }

    public HTTPRequestContext put(URL url) {
        return this.newRequest(HTTPMethod.PUT, url);
    }

    public HTTPRequestContext delete(URL url) {
        return this.newRequest(HTTPMethod.DELETE, url);
    }

    public HTTPRequestContext head(URL url) {
        return this.newRequest(HTTPMethod.HEAD, url);
    }

    public HTTPRequestContext newRequest(HTTPMethod method, URL url) {
        return (HTTPRequestContext)((HTTPRequestContext)((HTTPRequestContext)new HTTPRequestContext(this, method, url).timeout(this.timeout)).acceptCompress(this.acceptCompress)).userAgent(this.userAgent);
    }

    public HTTPRequestContext get(String url) {
        return this.newRequest(HTTPMethod.GET, url);
    }

    public HTTPRequestContext post(String url) {
        return this.newRequest(HTTPMethod.POST, url);
    }

    public HTTPRequestContext put(String url) {
        return this.newRequest(HTTPMethod.PUT, url);
    }

    public HTTPRequestContext delete(String url) {
        return this.newRequest(HTTPMethod.DELETE, url);
    }

    public HTTPRequestContext head(String url) {
        return this.newRequest(HTTPMethod.HEAD, url);
    }

    public HTTPRequestContext newRequest(HTTPMethod method, String urlStr) {
        URL url;
        try {
            url = new URL(Objects.requireNonNull(urlStr));
        }
        catch (MalformedURLException e) {
            throw new RequestsException("Resolve url error, url: " + urlStr, e);
        }
        return this.newRequest(method, url);
    }

    public String name() {
        return this.name;
    }

    public Optional<ProxySelector> proxy() {
        return Optional.ofNullable(this.proxySelector);
    }

    public boolean useHttp2() {
        return this.useHttp2;
    }

    public boolean verifyCert() {
        return this.verifyCert;
    }

    public boolean followRedirect() {
        return this.followRedirect;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public boolean acceptCompress() {
        return this.acceptCompress;
    }

    public Optional<Authenticator> authenticator() {
        return Optional.ofNullable(this.authenticator);
    }

    public CookieHandler cookieHandler() {
        return this.cookieHandler;
    }

    public Optional<KeyStore> keyStore() {
        return Optional.ofNullable(this.keyStore);
    }

    public Executor executor() {
        return this.executor;
    }

    public Optional<JsonMarshaller> jsonMarshaller() {
        return Optional.ofNullable(this.jsonMarshaller);
    }
}

