/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import net.dongliu.commons.reflect.TypeInfer;
import net.dongliu.cute.http.BodySubscriberProvider;
import net.dongliu.cute.http.HTTPHeaders;
import net.dongliu.cute.http.HTTPMethod;
import net.dongliu.cute.http.HTTPResponse;
import net.dongliu.cute.http.RawHTTPResponse;
import net.dongliu.cute.http.ResponseInfo;
import net.dongliu.cute.http.exception.JsonMarshallerNotFoundException;
import net.dongliu.cute.http.internal.AsyncInflater;
import net.dongliu.cute.http.json.JsonMarshaller;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AsyncHTTPResponseContext {
    private final CompletableFuture<RawHTTPResponse<Flow.Publisher<List<ByteBuffer>>>> responseFuture;
    private final @Nullable JsonMarshaller jsonMarshaller;
    private boolean autoDecompress = true;

    AsyncHTTPResponseContext(CompletableFuture<RawHTTPResponse<Flow.Publisher<List<ByteBuffer>>>> responseFuture, @Nullable JsonMarshaller jsonMarshaller) {
        this.responseFuture = responseFuture;
        this.jsonMarshaller = jsonMarshaller;
    }

    public AsyncHTTPResponseContext autoDecompress(boolean autoDecompress) {
        this.autoDecompress = autoDecompress;
        return this;
    }

    public <T> CompletableFuture<HTTPResponse<T>> handle(BodySubscriberProvider<T> subscriberProvider) {
        Objects.requireNonNull(subscriberProvider);
        return this.responseFuture.thenCompose(resp -> {
            ResponseInfo respInfo = resp.info();
            Flow.Publisher<List<ByteBuffer>> bodyPublisher = (Flow.Publisher<List<ByteBuffer>>)resp.body();
            if (this.autoDecompress) {
                bodyPublisher = this.wrapCompressedPublisher(resp.method(), respInfo.statusCode(), respInfo.headers(), (Flow.Publisher)resp.body());
            }
            HttpResponse.BodySubscriber subscriber = subscriberProvider.getBodySubscriber(respInfo);
            bodyPublisher.subscribe(subscriber);
            CompletionStage<Object> bodyFuture = subscriber.getBody();
            return bodyFuture.thenApply(body -> new HTTPResponse<Object>(resp.url(), respInfo.statusCode(), respInfo.headers(), body));
        });
    }

    public <T, R> CompletableFuture<HTTPResponse<R>> handle(BodySubscriberProvider<T> subscriberProvider, Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(subscriberProvider);
        Objects.requireNonNull(mapper);
        return this.handle(respInfo -> HttpResponse.BodySubscribers.mapping(subscriberProvider.getBodySubscriber(respInfo), mapper));
    }

    public CompletableFuture<HTTPResponse<String>> readToString(Charset charset) {
        Objects.requireNonNull(charset);
        return this.handle(info -> HttpResponse.BodySubscribers.ofString(charset));
    }

    public CompletableFuture<HTTPResponse<String>> readToString() {
        return this.handle(info -> HttpResponse.BodySubscribers.ofString(info.getCharset().orElse(StandardCharsets.UTF_8)));
    }

    public CompletableFuture<HTTPResponse<byte[]>> readToBytes() {
        return this.handle(info -> HttpResponse.BodySubscribers.ofByteArray());
    }

    public <T> CompletableFuture<HTTPResponse<T>> decodeJson(Class<T> type) {
        Objects.requireNonNull(type);
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        return this.handle(info -> HttpResponse.BodySubscribers.ofString(info.getCharset().orElse(StandardCharsets.UTF_8)), s -> this.decodeJson((String)s, type));
    }

    public <T> CompletableFuture<HTTPResponse<T>> decodeJson(TypeInfer<T> typeInfer) {
        Objects.requireNonNull(typeInfer);
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        return this.handle(info -> HttpResponse.BodySubscribers.ofString(info.getCharset().orElse(StandardCharsets.UTF_8)), s -> this.decodeJson((String)s, typeInfer.getType()));
    }

    public <T> CompletableFuture<HTTPResponse<T>> decodeJson(Class<T> type, Charset charset) {
        Objects.requireNonNull(type);
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        return this.handle(info -> HttpResponse.BodySubscribers.ofString(charset), s -> this.decodeJson((String)s, type));
    }

    public <T> CompletableFuture<HTTPResponse<T>> decodeJson(TypeInfer<T> typeInfer, Charset charset) {
        Objects.requireNonNull(typeInfer);
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        return this.handle(info -> HttpResponse.BodySubscribers.ofString(charset), s -> this.decodeJson((String)s, typeInfer.getType()));
    }

    private <T> T decodeJson(String json, Type type) {
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        StringReader reader = new StringReader(json);
        try {
            Object t = this.jsonMarshaller.unmarshal(reader, type);
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public CompletableFuture<HTTPResponse<Void>> discard() {
        return this.handle(info -> HttpResponse.BodySubscribers.discarding());
    }

    public CompletableFuture<HTTPResponse<Path>> writeTo(Path path) {
        return this.handle(info -> HttpResponse.BodySubscribers.ofFile(path));
    }

    private Flow.Publisher<List<ByteBuffer>> wrapCompressedPublisher(HTTPMethod method, int status, HTTPHeaders headers, Flow.Publisher<List<ByteBuffer>> publisher) {
        String contentEncoding;
        if (this.responseHasNoBody(method, status)) {
            return publisher;
        }
        switch (contentEncoding = headers.getHeader("Content-Encoding").orElse("").trim()) {
            case "gzip": {
                return subscriber -> publisher.subscribe(new DecompressedBodySubscriber(subscriber, 1));
            }
            case "deflate": {
                return subscriber -> publisher.subscribe(new DecompressedBodySubscriber(subscriber, 2));
            }
        }
        return publisher;
    }

    private boolean responseHasNoBody(HTTPMethod method, int status) {
        return method.equals((Object)HTTPMethod.HEAD) || status >= 100 && status < 200 || status == 304 || status == 204;
    }

    private static class DecompressedBodySubscriber
    implements Flow.Subscriber<List<ByteBuffer>> {
        private final Flow.Subscriber<? super List<ByteBuffer>> subscriber;
        private final AsyncInflater asyncInflater;

        public DecompressedBodySubscriber(Flow.Subscriber<? super List<ByteBuffer>> subscriber, int wrapper) {
            this.subscriber = subscriber;
            this.asyncInflater = new AsyncInflater(wrapper);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscriber.onSubscribe(subscription);
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            ArrayList buffers = new ArrayList();
            for (ByteBuffer in : item) {
                this.asyncInflater.decode(in, buffers::add);
            }
            this.subscriber.onNext(buffers);
        }

        @Override
        public void onError(Throwable throwable) {
            this.asyncInflater.onFinish();
            this.subscriber.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.asyncInflater.onFinish();
            this.subscriber.onComplete();
        }
    }
}

