package net.dongliu.cute.http;

import java.nio.charset.Charset;
import java.util.Optional;

/**
 * Carry the http response info, mainly the http status code and headers.
 */
public class ResponseInfo {

    private final int statusCode;
    private final HTTPHeaders headers;

    ResponseInfo(int statusCode, HTTPHeaders headers) {
        this.statusCode = statusCode;
        this.headers = headers;
    }

    /**
     * the http response status
     */
    public int statusCode() {
        return statusCode;
    }

    /**
     * the http response headers
     */
    public HTTPHeaders headers() {
        return headers;
    }

    /**
     * Get the charset set in response header. If not set, return empty Optional
     */
    public Optional<Charset> getCharset() {
        return headers.contentType().flatMap(ContentType::charset);
    }
}
