package net.dongliu.cute.http;

import net.dongliu.commons.Lazy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Collection of Cookie
 */
public class HTTPCookies {
    private final List<HTTPCookie> cookies;
    private final Lazy<Map<String, HTTPCookie>> map;

    /**
     * only for internal use
     */
    HTTPCookies(List<HTTPCookie> cookies) {
        this.cookies = List.copyOf(cookies);
        this.map = Lazy.of(() -> toMap(cookies));
    }

    private static Map<String, HTTPCookie> toMap(List<HTTPCookie> cookies) {
        var map = new HashMap<String, HTTPCookie>();
        for (HTTPCookie cookie : cookies) {
            map.put(cookie.name(), cookie);
        }
        return map;
    }

    /**
     * Get cookie with name, if not exists, return empty Optional
     */
    public Optional<HTTPCookie> getCookie(String name) {
        var c = map.get().get(name);
        return Optional.ofNullable(c);
    }

    /**
     * Return all cookies
     */
    public List<HTTPCookie> allCookies() {
        return cookies;
    }
}
