package net.dongliu.cute.http;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow.Publisher;

/**
 * Consumer the response body, and when consumer finished, return the transformed value. The implementations should not block caller thread.
 * @param <T> the converted body type
 */
@FunctionalInterface
public interface AsyncHTTPResponseHandler<T> {

    /**
     * A async method, that handle and transform response body.
     */
    CompletionStage<T> handle(ResponseInfo info, Publisher<List<ByteBuffer>> body);
}
