/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.body;

import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Flow;

class AggregateBodyPublisher
implements HttpRequest.BodyPublisher {
    private final HttpRequest.BodyPublisher[] publishers;
    private final long len;

    AggregateBodyPublisher(List<HttpRequest.BodyPublisher> publishers) {
        this.publishers = (HttpRequest.BodyPublisher[])publishers.toArray(HttpRequest.BodyPublisher[]::new);
        this.len = AggregateBodyPublisher.accumulateLen(publishers);
    }

    private static long accumulateLen(List<HttpRequest.BodyPublisher> publishers) {
        int len = 0;
        for (HttpRequest.BodyPublisher publisher : publishers) {
            if (publisher.contentLength() < 0L) {
                return -1L;
            }
            len = (int)((long)len + publisher.contentLength());
        }
        return len;
    }

    @Override
    public long contentLength() {
        return this.len;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        AggregateSubscription aggregateSubscription = new AggregateSubscription(this.publishers, subscriber);
        subscriber.onSubscribe(aggregateSubscription);
    }

    private static class AggregateSubscription
    implements Flow.Subscription {
        private final HttpRequest.BodyPublisher[] publishers;
        private final Flow.Subscriber<? super ByteBuffer> subscriber;
        private final SubscriberAdapter subscriberAdapter;
        private Flow.Subscription currentSubscription;
        private long requestCount = 0L;
        private int index = 0;

        private AggregateSubscription(HttpRequest.BodyPublisher[] publishers, Flow.Subscriber<? super ByteBuffer> subscriber) {
            this.publishers = publishers;
            this.subscriber = subscriber;
            this.subscriberAdapter = new SubscriberAdapter();
            publishers[0].subscribe(this.subscriberAdapter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            AggregateSubscription aggregateSubscription = this;
            synchronized (aggregateSubscription) {
                this.requestCount += n;
                this.currentSubscription.request(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            AggregateSubscription aggregateSubscription = this;
            synchronized (aggregateSubscription) {
                this.currentSubscription.cancel();
            }
        }

        private class SubscriberAdapter
        implements Flow.Subscriber<ByteBuffer> {
            private SubscriberAdapter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                AggregateSubscription aggregateSubscription = AggregateSubscription.this;
                synchronized (aggregateSubscription) {
                    AggregateSubscription.this.currentSubscription = subscription;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(ByteBuffer item) {
                AggregateSubscription aggregateSubscription = AggregateSubscription.this;
                synchronized (aggregateSubscription) {
                    --AggregateSubscription.this.requestCount;
                }
                AggregateSubscription.this.subscriber.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                AggregateSubscription.this.subscriber.onError(throwable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete() {
                AggregateSubscription aggregateSubscription = AggregateSubscription.this;
                synchronized (aggregateSubscription) {
                    ++AggregateSubscription.this.index;
                    if (AggregateSubscription.this.index == AggregateSubscription.this.publishers.length) {
                        AggregateSubscription.this.subscriber.onComplete();
                    } else {
                        HttpRequest.BodyPublisher bodyPublisher = AggregateSubscription.this.publishers[AggregateSubscription.this.index];
                        bodyPublisher.subscribe(this);
                        if (AggregateSubscription.this.requestCount > 0L) {
                            AggregateSubscription.this.currentSubscription.request(AggregateSubscription.this.requestCount);
                            AggregateSubscription.this.requestCount = 0L;
                        }
                    }
                }
            }
        }
    }
}

