/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.util.Objects;
import net.dongliu.cute.http.NameValue;

public class Param
implements NameValue {
    private final String name;
    private final String value;

    private Param(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static Param of(String name, String value) {
        return new Param(Objects.requireNonNull(name), Objects.requireNonNull(value));
    }

    public static Param of(String name, long value) {
        return new Param(Objects.requireNonNull(name), String.valueOf(value));
    }

    public static Param of(String name, boolean value) {
        return new Param(Objects.requireNonNull(name), String.valueOf(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Param param = (Param)o;
        return Objects.equals(this.name, param.name) && Objects.equals(this.value, param.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public boolean nameCaseSensitive() {
        return true;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.name + "=" + this.value;
    }
}

