/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import net.dongliu.commons.io.InputStreams;
import net.dongliu.commons.io.Readers;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.HTTPHeaders;
import net.dongliu.cute.http.HTTPMethod;
import net.dongliu.cute.http.HTTPResponse;
import net.dongliu.cute.http.ResponseHandler;
import net.dongliu.cute.http.ResponseInfo;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HTTPResponseContext
implements AutoCloseable {
    private final HTTPMethod method;
    private final URL url;
    private final ResponseInfo info;
    private @Nullable Charset charset = null;
    private boolean autoDecompress = true;

    HTTPResponseContext(HTTPMethod method, URL url, ResponseInfo info) {
        this.method = method;
        this.url = url;
        this.info = Objects.requireNonNull(info);
    }

    public HTTPResponseContext charset(Charset charset) {
        this.charset = Objects.requireNonNull(charset);
        return this;
    }

    public HTTPResponseContext autoDecompress(boolean autoDecompress) {
        this.autoDecompress = autoDecompress;
        return this;
    }

    public <T> HTTPResponse<T> handle(ResponseHandler<T> responseHandler) {
        HTTPResponse<T> hTTPResponse;
        block9: {
            InputStream body;
            ResponseInfo info = this.info;
            if (this.autoDecompress) {
                body = this.wrapCompressedInput(this.method, info.statusCode(), info.headers(), info.body());
                info = new ResponseInfo(info.statusCode(), info.headers(), body);
            }
            body = info.body();
            try {
                T result = responseHandler.handle(info.statusCode(), info.headers(), body, this::getCharset);
                hTTPResponse = new HTTPResponse<T>(this.url, info.statusCode(), info.headers(), result);
                if (body == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            body.close();
        }
        return hTTPResponse;
    }

    private InputStream wrapCompressedInput(HTTPMethod method, int status, HTTPHeaders headers, InputStream input) {
        String contentEncoding;
        if (this.noBody(method, status)) {
            return input;
        }
        switch (contentEncoding = headers.getHeader("Content-Encoding").orElse("")) {
            case "gzip": {
                try {
                    return new GZIPInputStream(input);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            case "deflate": {
                return new InflaterInputStream(input, new Inflater(true));
            }
        }
        return input;
    }

    private boolean noBody(HTTPMethod method, int status) {
        return method.equals((Object)HTTPMethod.HEAD) || status >= 100 && status < 200 || status == 304 || status == 204;
    }

    public HTTPResponse<String> toStringResponse() {
        return this.handle((statusCode, headers, body, charset) -> {
            try (InputStreamReader reader = new InputStreamReader(body, (Charset)charset.get());){
                String string = Readers.readAll((Reader)reader);
                return string;
            }
        });
    }

    public HTTPResponse<byte[]> toBinaryResponse() {
        return this.handle((statusCode, headers, body, charset) -> body.readAllBytes());
    }

    public HTTPResponse<Path> writeTo(Path path) {
        return this.handle((statusCode, headers, body, charset) -> {
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                body.transferTo(out);
            }
            return null;
        });
    }

    public HTTPResponse<Void> writeTo(OutputStream out) {
        return this.handle((statusCode, headers, body, charset) -> {
            body.transferTo(out);
            return null;
        });
    }

    public HTTPResponse<Void> writeTo(Writer writer) {
        return this.handle((statusCode, headers, body, charset) -> {
            try (InputStreamReader reader = new InputStreamReader(body, (Charset)charset.get());){
                Readers.transferTo((Reader)reader, (Writer)writer);
                Void void_ = null;
                return void_;
            }
        });
    }

    public HTTPResponse<Void> discard() {
        return this.handle((statusCode, headers, body, charset) -> {
            InputStreams.discardAll((InputStream)body);
            return null;
        });
    }

    public <T> HTTPResponse<T> handleAsReader(Function<? super Reader, T> handler) {
        return this.handle((statusCode, headers, body, charset) -> {
            try (InputStreamReader reader = new InputStreamReader(body, (Charset)charset.get());){
                Object r = handler.apply(reader);
                return r;
            }
        });
    }

    public <T> HTTPResponse<T> handleAsInput(Function<? super InputStream, T> handler) {
        return this.handle((statusCode, headers, body, charset) -> handler.apply(body));
    }

    private Charset getCharset() {
        if (this.charset != null) {
            return this.charset;
        }
        return this.info.headers().contentType().flatMap(ContentType::charset).orElse(StandardCharsets.UTF_8);
    }

    @Override
    public void close() {
        this.discard();
    }
}

