/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.net.HttpCookie;
import java.net.http.HttpHeaders;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import net.dongliu.commons.Lazy;
import net.dongliu.commons.Optionals;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.collection.Maps;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.HTTPCookie;
import net.dongliu.cute.http.HTTPCookies;
import net.dongliu.cute.http.HTTPHeader;

public class HTTPHeaders {
    private final Map<String, List<String>> map;
    private final Lazy<HTTPCookies> cookies;
    private final Lazy<Optional<ContentType>> contentType;

    private HTTPHeaders(Map<String, List<String>> map) {
        this.map = Objects.requireNonNull(map);
        this.cookies = Lazy.of(this::parseCookies);
        this.contentType = Lazy.of(() -> this.getHeader("Content-Type").flatMap(ContentType::safeParse));
    }

    public static HTTPHeaders ofHttpHeaders(HttpHeaders httpHeaders) {
        return new HTTPHeaders(httpHeaders.map());
    }

    public static HTTPHeaders of(Collection<? extends HTTPHeader> headers) {
        Map map = Maps.newCaseInsensitiveMap();
        for (HTTPHeader hTTPHeader : headers) {
            map.computeIfAbsent(hTTPHeader.name(), name -> new ArrayList(2)).add(hTTPHeader.value());
        }
        return new HTTPHeaders(HTTPHeaders.copyImmutable(map));
    }

    private static Map<String, List<String>> copyImmutable(Map<String, List<String>> map) {
        Map newMap = Maps.newCaseInsensitiveMap();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            newMap.put(entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        return Collections.unmodifiableMap(newMap);
    }

    private HTTPCookies parseCookies() {
        List<String> cookieValues = this.getHeaders("Set-Cookie");
        Instant createTime = Instant.now();
        List<HTTPCookie> cookieList = cookieValues.stream().flatMap(v -> HttpCookie.parse(v).stream()).map(c -> HTTPHeaders.ofHttpCookie(createTime, c)).collect(Collectors.toUnmodifiableList());
        return new HTTPCookies(cookieList);
    }

    private static HTTPCookie ofHttpCookie(Instant createTime, HttpCookie httpCookie) {
        return new HTTPCookie(httpCookie.getName(), httpCookie.getValue(), httpCookie.getDomain(), httpCookie.getPath(), httpCookie.getMaxAge() < 0L ? OptionalLong.empty() : OptionalLong.of(httpCookie.getMaxAge()), httpCookie.getSecure(), httpCookie.isHttpOnly(), createTime);
    }

    public List<String> getHeaders(String name) {
        Objects.requireNonNull(name);
        return this.map.getOrDefault(name, List.of());
    }

    public Optional<String> getHeader(String name) {
        Objects.requireNonNull(name);
        return Lists.first(this.getHeaders(name));
    }

    public OptionalLong getLongHeader(String name) {
        Optional<String> header = this.getHeader(name);
        return Optionals.mapToLong(header, Long::parseLong);
    }

    public Map<String, List<String>> allHeaders() {
        return this.map;
    }

    public Optional<ContentType> contentType() {
        return (Optional)this.contentType.get();
    }

    public HTTPCookies cookies() {
        return (HTTPCookies)this.cookies.get();
    }
}

