/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dongliu.commons.Lazy;
import net.dongliu.cute.http.HTTPCookie;

public class HTTPCookies {
    private final List<HTTPCookie> cookies;
    private final Lazy<Map<String, HTTPCookie>> map;

    HTTPCookies(List<HTTPCookie> cookies) {
        this.cookies = List.copyOf(cookies);
        this.map = Lazy.of(() -> HTTPCookies.toMap(cookies));
    }

    private static Map<String, HTTPCookie> toMap(List<HTTPCookie> cookies) {
        HashMap<String, HTTPCookie> map = new HashMap<String, HTTPCookie>();
        for (HTTPCookie cookie : cookies) {
            map.put(cookie.name(), cookie);
        }
        return map;
    }

    public Optional<HTTPCookie> getCookie(String name) {
        HTTPCookie c = (HTTPCookie)((Map)this.map.get()).get(name);
        return Optional.ofNullable(c);
    }

    public List<HTTPCookie> allCookies() {
        return this.cookies;
    }
}

