/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.io.IOException;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.dongliu.commons.concurrent.Futures;
import net.dongliu.commons.io.Closeables;
import net.dongliu.cute.http.AsyncHTTPResponseHandler;
import net.dongliu.cute.http.AsyncResponseInfo;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.HTTPHeaders;
import net.dongliu.cute.http.HTTPMethod;
import net.dongliu.cute.http.HTTPResponse;
import net.dongliu.cute.http.internal.AsyncInflater;
import net.dongliu.cute.http.internal.ByteBuffers;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AsyncHTTPResponseContext {
    private final HTTPMethod method;
    private final CompletableFuture<AsyncResponseInfo> infoFuture;
    private @Nullable Charset charset = null;
    private boolean autoDecompress = true;

    AsyncHTTPResponseContext(HTTPMethod method, CompletableFuture<AsyncResponseInfo> infoFuture) {
        this.method = method;
        this.infoFuture = infoFuture;
    }

    public AsyncHTTPResponseContext charset(Charset charset) {
        this.charset = Objects.requireNonNull(charset);
        return this;
    }

    public AsyncHTTPResponseContext autoDecompress(boolean autoDecompress) {
        this.autoDecompress = autoDecompress;
        return this;
    }

    public <T> CompletableFuture<HTTPResponse<T>> handle(AsyncHTTPResponseHandler<T> handler) {
        Objects.requireNonNull(handler);
        return this.infoFuture.thenCompose(info -> {
            AsyncResponseInfo asyncResponseInfo = info;
            if (this.autoDecompress) {
                Flow.Publisher<List<ByteBuffer>> publisher = this.wrapCompressedPublisher(this.method, info.statusCode(), info.headers(), info.body());
                asyncResponseInfo = new AsyncResponseInfo(info.url(), info.statusCode(), info.headers(), publisher);
            }
            AsyncResponseInfo finalInfo = asyncResponseInfo;
            try {
                handler.onHeader(info.statusCode(), info.headers(), () -> this.getCharset(finalInfo));
            }
            catch (Throwable e) {
                return Futures.error((Throwable)e);
            }
            BodyHandlerSubscriber bodySubscriber = new BodyHandlerSubscriber(handler);
            info.body().subscribe(bodySubscriber);
            CompletableFuture bodyFuture = bodySubscriber.getBody().toCompletableFuture();
            return bodyFuture.thenApply(body -> new HTTPResponse<Object>(info.url(), finalInfo.statusCode(), finalInfo.headers(), body));
        });
    }

    public CompletableFuture<HTTPResponse<String>> toStringResponse() {
        return this.handle(new AsyncHTTPResponseHandler<String>(){
            private Charset charset;
            private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();

            @Override
            public void onHeader(int statusCode, HTTPHeaders headers, Supplier<Charset> charset) {
                this.charset = charset.get();
            }

            @Override
            public void onBodyChunk(ByteBuffer buffer) {
                this.buffers.add(buffer);
            }

            @Override
            public String onBodyEnd() {
                return ByteBuffers.toString(this.buffers, this.charset);
            }
        });
    }

    public CompletableFuture<HTTPResponse<byte[]>> toBinaryResponse() {
        return this.handle(new AsyncHTTPResponseHandler<byte[]>(){
            private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();

            @Override
            public void onBodyChunk(ByteBuffer buffer) {
                this.buffers.add(buffer);
            }

            @Override
            public byte[] onBodyEnd() {
                return ByteBuffers.toByteArray(this.buffers);
            }
        });
    }

    public CompletableFuture<HTTPResponse<Void>> discard() {
        return this.handle(new AsyncHTTPResponseHandler<Void>(){

            @Override
            public void onBodyChunk(ByteBuffer buffer) {
            }

            @Override
            public Void onBodyEnd() {
                return null;
            }
        });
    }

    public CompletableFuture<HTTPResponse<Path>> writeTo(final Path path) {
        return this.handle(new AsyncHTTPResponseHandler<Path>(){
            private FileChannel channel;

            @Override
            public void onHeader(int statusCode, HTTPHeaders headers, Supplier<Charset> charset) throws IOException {
                this.channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }

            @Override
            public void onBodyChunk(ByteBuffer buffer) throws IOException {
                try {
                    this.channel.write(buffer);
                }
                catch (Throwable e) {
                    Closeables.closeQuietly((AutoCloseable)this.channel);
                    throw e;
                }
            }

            @Override
            public Path onBodyEnd() {
                Closeables.closeQuietly((AutoCloseable)this.channel);
                return path;
            }
        });
    }

    private Charset getCharset(AsyncResponseInfo info) {
        if (this.charset != null) {
            return this.charset;
        }
        return info.headers().contentType().flatMap(ContentType::charset).orElse(StandardCharsets.UTF_8);
    }

    private Flow.Publisher<List<ByteBuffer>> wrapCompressedPublisher(HTTPMethod method, int status, HTTPHeaders headers, Flow.Publisher<List<ByteBuffer>> publisher) {
        String contentEncoding;
        if (this.responseHasNoBody(method, status)) {
            return publisher;
        }
        switch (contentEncoding = headers.getHeader("Content-Encoding").orElse("").trim()) {
            case "gzip": {
                return subscriber -> publisher.subscribe(new DecompressedBodySubscriber(subscriber, 1));
            }
            case "deflate": {
                return subscriber -> publisher.subscribe(new DecompressedBodySubscriber(subscriber, 2));
            }
        }
        return publisher;
    }

    private boolean responseHasNoBody(HTTPMethod method, int status) {
        return method.equals((Object)HTTPMethod.HEAD) || status >= 100 && status < 200 || status == 304 || status == 204;
    }

    private static class BodyHandlerSubscriber<T>
    implements HttpResponse.BodySubscriber<T> {
        private final AsyncHTTPResponseHandler<T> handler;
        private Flow.Subscription subscription;
        private final CompletableFuture<T> result = new CompletableFuture();
        private final AtomicBoolean subscribed = new AtomicBoolean();

        public BodyHandlerSubscriber(AsyncHTTPResponseHandler<T> handler) {
            this.handler = Objects.requireNonNull(handler);
        }

        @Override
        public CompletionStage<T> getBody() {
            return this.result;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (!this.subscribed.compareAndSet(false, true)) {
                subscription.cancel();
            } else {
                this.subscription = subscription;
                subscription.request(1L);
            }
        }

        @Override
        public void onNext(List<ByteBuffer> items) {
            for (ByteBuffer item : items) {
                try {
                    this.handler.onBodyChunk(item);
                }
                catch (Throwable e) {
                    this.result.completeExceptionally(e);
                    this.subscription.cancel();
                    return;
                }
            }
            this.subscription.request(1L);
        }

        @Override
        public void onError(Throwable throwable) {
            this.result.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            try {
                this.result.complete(this.handler.onBodyEnd());
            }
            catch (Throwable e) {
                this.result.completeExceptionally(e);
            }
        }
    }

    private static class DecompressedBodySubscriber
    implements Flow.Subscriber<List<ByteBuffer>> {
        private final Flow.Subscriber<? super List<ByteBuffer>> subscriber;
        private final AsyncInflater asyncInflater;

        public DecompressedBodySubscriber(Flow.Subscriber<? super List<ByteBuffer>> subscriber, int wrapper) {
            this.subscriber = subscriber;
            this.asyncInflater = new AsyncInflater(wrapper);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscriber.onSubscribe(subscription);
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            ArrayList buffers = new ArrayList();
            for (ByteBuffer in : item) {
                this.asyncInflater.decode(in, buffers::add);
            }
            this.subscriber.onNext(buffers);
        }

        @Override
        public void onError(Throwable throwable) {
            this.asyncInflater.onFinish();
            this.subscriber.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.asyncInflater.onFinish();
            this.subscriber.onComplete();
        }
    }
}

