/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dongliu.commons.collection.Collections2;
import net.dongliu.cute.http.HTTPCookie;
import net.dongliu.cute.http.HTTPHeader;
import net.dongliu.cute.http.HTTPMethod;
import net.dongliu.cute.http.HTTPRequest;
import net.dongliu.cute.http.Param;
import net.dongliu.cute.http.body.Body;
import net.dongliu.cute.http.internal.Asserts;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractHTTPRequestBuilder<T extends AbstractHTTPRequestBuilder> {
    final HTTPMethod method;
    final URL url;
    List<HTTPHeader> headers = List.of();
    List<HTTPCookie> cookies = List.of();
    List<Param> params = List.of();
    Charset paramCharset = StandardCharsets.UTF_8;
    @Nullable Body<?> body = null;
    @Nullable PasswordAuthentication basicAuth = null;
    Duration timeout = Duration.ofSeconds(10L);
    @Nullable String userAgent = null;
    @Nullable String referer = null;
    boolean acceptCompress = true;

    AbstractHTTPRequestBuilder(HTTPMethod method, URL url) {
        this.method = Objects.requireNonNull(method);
        this.url = Objects.requireNonNull(url);
    }

    public T timeout(Duration timeout) {
        this.timeout = Asserts.checkTimeout(timeout);
        return this.self();
    }

    public T userAgent(String userAgent) {
        this.userAgent = Objects.requireNonNull(userAgent);
        return this.self();
    }

    public T referer(String referer) {
        this.referer = Objects.requireNonNull(referer);
        return this.self();
    }

    public T headers(List<HTTPHeader> headers) {
        this.headers = Objects.requireNonNull(headers);
        return this.self();
    }

    public final T headers(HTTPHeader ... headers) {
        this.headers(List.of(headers));
        return this.self();
    }

    public final T headers(Map<String, String> map) {
        this.headers = Collections2.convertToList(map.entrySet(), e -> HTTPHeader.of((String)e.getKey(), (String)e.getValue()));
        return this.self();
    }

    public T cookies(List<HTTPCookie> cookies) {
        this.cookies = cookies;
        return this.self();
    }

    public final T cookies(HTTPCookie ... cookies) {
        this.cookies(List.of(cookies));
        return this.self();
    }

    public final T cookies(Map<String, String> map) {
        this.cookies = Collections2.convertToList(map.entrySet(), e -> HTTPCookie.of((String)e.getKey(), (String)e.getValue()));
        return this.self();
    }

    public T params(List<Param> params) {
        this.params = Objects.requireNonNull(params);
        return this.self();
    }

    public T params(List<Param> params, Charset charset) {
        this.params = Objects.requireNonNull(params);
        this.paramCharset = charset;
        return this.self();
    }

    public final T params(Param ... params) {
        this.params = List.of(params);
        return this.self();
    }

    public final T params(Map<String, String> map) {
        this.params = Collections2.convertToList(map.entrySet(), e -> Param.of((String)e.getKey(), (String)e.getValue()));
        return this.self();
    }

    public final T params(Map<String, String> map, Charset charset) {
        this.params = Collections2.convertToList(map.entrySet(), e -> Param.of((String)e.getKey(), (String)e.getValue()));
        this.paramCharset = charset;
        return this.self();
    }

    public T body(Body<?> body) {
        this.body = Objects.requireNonNull(body);
        return this.self();
    }

    public T acceptCompress(boolean acceptCompress) {
        this.acceptCompress = acceptCompress;
        return this.self();
    }

    public T basicAuth(String user, char[] password) {
        return this.basicAuth(new PasswordAuthentication(Objects.requireNonNull(user), Objects.requireNonNull(password)));
    }

    public T basicAuth(PasswordAuthentication basicAuth) {
        this.basicAuth = Objects.requireNonNull(basicAuth);
        return this.self();
    }

    public HTTPRequest build() {
        return new HTTPRequest(this);
    }

    protected abstract T self();
}

