package net.dongliu.cute.http.body;

import net.dongliu.cute.http.ContentType;

import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;

import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * Request Body with text content.
 *
 * @author Liu Dong
 */
class StringBody extends AbstractBody<String> {

    StringBody(String body, ContentType contentType) {
        super(body, contentType);
    }

    @Override
    public BodyPublisher asBodyPublisher() {
        var charset = contentType().charset().orElse(UTF_8);
        return BodyPublishers.ofInputStream(InputSuppliers.of(body(), charset));
    }
}
