package net.dongliu.cute.http.body;

import net.dongliu.cute.http.ContentType;

import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;

/**
 * This Request Body which provided by InputStream.
 *
 * @author Liu Dong
 */
class InputStreamBody extends AbstractBody<InputSupplier> {

    InputStreamBody(InputSupplier body, ContentType contentType) {
        super(body, contentType);
    }

    @Override
    public BodyPublisher asBodyPublisher() {
        return BodyPublishers.ofInputStream(body());
    }
}
