package net.dongliu.cute.http.body;

import net.dongliu.cute.http.MimeType;
import net.dongliu.cute.http.internal.UrlUtils;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.Param;

import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;
import java.nio.charset.Charset;
import java.util.List;

import static java.nio.charset.StandardCharsets.UTF_8;

/**
 * Post www-form-encoded body
 *
 * @author Liu Dong
 */
class FormBody extends AbstractBody<List<Param>> {

    FormBody(List<Param> body, Charset charset) {
        super(body, ContentType.of(MimeType.WWW_FORM_ENCODED, charset));
    }

    @Override
    public BodyPublisher asBodyPublisher() {
        Charset charset = contentType().charset().orElse(UTF_8);
        String content = UrlUtils.encodeForms(body(), charset);
        return BodyPublishers.ofInputStream(InputSuppliers.of(content, charset));
    }
}
