package net.dongliu.cute.http.body;

import net.dongliu.cute.http.MimeType;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;

class FileTypes {

    static Optional<MimeType> detectFileType(Path path) {
        try {
            String probeContentType = Files.probeContentType(path);
            return MimeType.safeParse(probeContentType);
        } catch (Exception e) {
            return Optional.empty();
        }
    }
}
