package net.dongliu.cute.http.body;

import net.dongliu.cute.http.ContentType;

import java.net.http.HttpRequest.BodyPublisher;
import java.net.http.HttpRequest.BodyPublishers;

/**
 * Request body contains binary content.
 *
 * @author Liu Dong
 */
class BinaryBody extends AbstractBody<byte[]> {

    BinaryBody(byte[] body, ContentType contentType) {
        super(body, contentType);
    }


    @Override
    public BodyPublisher asBodyPublisher() {
        return BodyPublishers.ofByteArray(body());
    }
}
