package net.dongliu.cute.http;

import java.io.InputStream;

class ResponseInfo {

    private final int statusCode;
    private final HTTPHeaders headers;
    private final InputStream body;

    ResponseInfo(int statusCode, HTTPHeaders headers, InputStream body) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
    }

    /**
     * the http response status
     */
    public int statusCode() {
        return statusCode;
    }

    /**
     * the http response headers
     */
    public HTTPHeaders headers() {
        return headers;
    }

    /**
     * the http body as InputStream
     */
    public InputStream body() {
        return body;
    }
}
