package net.dongliu.cute.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Supplier;

/**
 * Handle response in blocking way.
 */
@FunctionalInterface
public interface ResponseHandler<T> {
    /**
     * Handler response body, convert to instance of type T.
     *
     * @return the value body convert to
     */
    T handle(int statusCode, HTTPHeaders headers, InputStream body, Supplier<Charset> charset) throws IOException;
}
