package net.dongliu.cute.http;

/**
 * Immutable name-value pair, the name and value cannot be null.
 *
 * @author Liu Dong
 */
public interface NameValue {

    /**
     * If name equals the given name.
     */
    default boolean nameEquals(String name) {
        if (nameCaseSensitive()) {
            return this.name().equals(name);
        } else {
            return this.name().equalsIgnoreCase(name);
        }
    }

    /**
     * If names are case sensitive
     */
    boolean nameCaseSensitive();

    /**
     * Return the name
     *
     * @return the name
     */
    String name();

    /**
     * Return the value
     */
    String value();

    @Override
    String toString();

    @Override
    int hashCode();

    @Override
    boolean equals(Object obj);
}
