package net.dongliu.cute.http;

import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Flow;

class AsyncResponseInfo {
    private final URL url;
    private final int statusCode;
    private final HTTPHeaders headers;
    private final Flow.Publisher<List<ByteBuffer>> body;

    public AsyncResponseInfo(URL url, int statusCode, HTTPHeaders headers, Flow.Publisher<List<ByteBuffer>> publisher) {
        this.url = url;
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = publisher;
    }

    /**
     * the final request url after redirected
     */
    public URL url() {
        return url;
    }

    /**
     * the http response status code
     */
    public int statusCode() {
        return statusCode;
    }

    /**
     * the http response headers
     */
    public HTTPHeaders headers() {
        return headers;
    }

    /**
     * the http body as ByteBuffer Publisher
     */
    public Flow.Publisher<List<ByteBuffer>> body() {
        return body;
    }
}
