package net.dongliu.cute.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.function.Supplier;

/**
 * Consumer the response body, and when consumer finished, return the transformed value. The implementations should not block caller thread.
 * <ul>
 * <li>The onHeader() method would be called first, when http headers has been fully received.</li>
 * <li>Then may call onBodyChunk() method one or more time</li>
 * <li>Then onBodyEnd() method would be called to fetch the result</li>
 * </ul>
 *
 * @param <T>
 */
public interface AsyncHTTPResponseHandler<T> {

    /**
     * Called when header arrived.
     */
    default void onHeader(int statusCode, HTTPHeaders headers, Supplier<Charset> charset) throws Exception {

    }

    /**
     * The passed in ByteBuffer may be reused at next call.
     *
     * @param buffer the ByteBuffer
     */
    void onBodyChunk(ByteBuffer buffer) throws Exception;

    /**
     * Get the valued transformed from response body.
     */
    T onBodyEnd() throws Exception;
}
