/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.parser.expression;

import net.diversionmc.parser.expression.ExpressionPiece;
import net.diversionmc.parser.expression.PieceResult;
import net.diversionmc.parser.util.FilePointer;
import net.diversionmc.parser.util.ParserException;

public class StringPiece
extends ExpressionPiece {
    private final char end;
    private char start;
    private final StringBuilder sb = new StringBuilder();
    private boolean escape = false;
    private boolean started = false;
    private int uExpected = 0;
    private char uChar;

    public StringPiece(FilePointer ptr, char end) {
        super(ptr);
        this.end = end;
    }

    @Override
    public PieceResult read(char c, FilePointer ptr) {
        if (this.uExpected > 0) {
            ParserException.ASSERT(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F', ptr, "Expecting a \\u-sequence, \"" + StringPiece.escape(c) + "\" is not a hex digit");
            this.uChar = (char)(this.uChar | Character.digit(c, 16) << (--this.uExpected << 2));
            if (this.uExpected == 0) {
                this.sb.append(this.uChar);
            }
            return PieceResult.CONTINUE;
        }
        if (!this.started) {
            this.started = true;
            if (true) {
                this.start = c;
                return PieceResult.CONTINUE;
            }
        }
        ParserException.ASSERT(c != '\n', ptr, "Cannot break lines mid-string");
        if (this.escape) {
            this.escape = false;
            if (c != this.end) {
                if (c == 'u') {
                    this.uChar = '\u0000';
                    this.uExpected = 4;
                    return PieceResult.CONTINUE;
                }
                c = switch (c) {
                    case 34, 39, 47, 92, 96 -> c;
                    case 110 -> '\n';
                    case 114 -> '\r';
                    case 102 -> '\f';
                    case 98 -> '\b';
                    case 116 -> '\t';
                    case 48 -> '\u0000';
                    default -> throw new ParserException("Unexpected escape sequence \"\\" + (char)c + "\"", ptr);
                };
            }
        } else {
            if (c == '\\' && c != this.end) {
                this.escape = true;
                return PieceResult.CONTINUE;
            }
            if (c == this.end) {
                return PieceResult.TAKE;
            }
        }
        this.sb.append(c);
        return PieceResult.CONTINUE;
    }

    public String content() {
        return String.valueOf(this.sb);
    }

    public String toString() {
        return this.start + StringPiece.escape(this.sb) + this.end;
    }

    public static String escape(char c) {
        char[] ins = new char[]{'\\', '\"', '\'', '\n', '\r', '\f', '\b', '\t', '\u0000'};
        char[] out = new char[]{'\\', '\"', '\'', 'n', 'r', 'f', 'b', 't', '0'};
        for (int j = 0; j < ins.length; ++j) {
            if (c != ins[j]) continue;
            return "\\" + out[j];
        }
        return "" + c;
    }

    public static String escape(CharSequence s) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            res.append(StringPiece.escape(s.charAt(i)));
        }
        return String.valueOf(res);
    }
}

