/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.parser.expression;

import net.diversionmc.parser.expression.ExpressionPiece;
import net.diversionmc.parser.expression.PieceResult;
import net.diversionmc.parser.util.FilePointer;

public class NumberPiece
extends ExpressionPiece {
    private final StringBuilder sb = new StringBuilder();
    private double num;

    public NumberPiece(FilePointer ptr) {
        super(ptr);
    }

    @Override
    public PieceResult read(char c, FilePointer ptr) {
        if (c == '-' && this.sb.isEmpty()) {
            this.sb.append(c);
            return PieceResult.CONTINUE;
        }
        Double num = NumberPiece.tryNumber(String.valueOf(this.sb.append(c)));
        if (num == null) {
            return PieceResult.LEAVE;
        }
        this.num = num;
        return PieceResult.CONTINUE;
    }

    public double number() {
        return this.num;
    }

    public static Double tryNumber(String s) {
        if (!s.trim().equals(s)) {
            return null;
        }
        try {
            return Long.decode(s).doubleValue();
        }
        catch (NumberFormatException e1) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
    }

    public static boolean tryBoolean(String s) {
        Double num = NumberPiece.tryNumber(s);
        return num == null ? "true".equalsIgnoreCase(s) : num != 0.0;
    }
}

