/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.diversionmc.parser.expression.ExpressionPiece;
import net.diversionmc.parser.expression.PiecePredicate;
import net.diversionmc.parser.expression.PieceResult;
import net.diversionmc.parser.expression.PieceSupplier;
import net.diversionmc.parser.group.GroupSupplier;
import net.diversionmc.parser.group.Grouper;
import net.diversionmc.parser.pattern.ParsePattern;
import net.diversionmc.parser.pattern.Sentence;
import net.diversionmc.parser.util.FilePointer;
import net.diversionmc.parser.util.ParserException;

public final class Parser<T extends Sentence> {
    private String name = "" + this.hashCode();
    private String text = null;
    private final List<ParsePiece> pieces = new LinkedList<ParsePiece>();
    private final List<Grouper<?, ?>> groups = new LinkedList();
    private final Map<String, ParsePattern<T>> patterns = new LinkedHashMap<String, ParsePattern<T>>();
    private Consumer<ExpressionPiece> pieceFinish = null;
    private Runnable pre = null;
    private FilePointer end;

    public Parser() {
    }

    public Parser(String name) {
        this.name = name;
    }

    public Parser(String name, String text) {
        this(name);
        this.text(text);
    }

    public Parser(String name, InputStream is) throws IOException {
        this(name);
        this.readFrom(is);
    }

    public Parser(File f) throws IOException {
        this.readFrom(f);
    }

    public static <T extends Sentence> Parser<T> parser() {
        return new Parser<T>();
    }

    public static <T extends Sentence> Parser<T> parser(String name) {
        return new Parser<T>(name);
    }

    public static <T extends Sentence> Parser<T> parser(String name, String text) {
        return new Parser<T>(name, text);
    }

    public static <T extends Sentence> Parser<T> parser(String name, InputStream is) throws IOException {
        return new Parser<T>(name, is);
    }

    public static <T extends Sentence> Parser<T> parser(File f) throws IOException {
        return new Parser<T>(f);
    }

    public String name() {
        return this.name;
    }

    public String text() {
        return this.text;
    }

    public Parser<T> text(String text) {
        ParserException.ASSERT(text != null, "Parser text is null");
        this.text = text + "\n";
        this.end = new FilePointer(this.name, Math.max(1, text.split("\n").length), 1);
        return this;
    }

    public Parser<T> readFrom(File f) throws IOException {
        String n;
        int i;
        ParserException.ASSERT(f != null, "Parser file is null");
        StringBuilder s = new StringBuilder();
        if (f.exists()) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));){
                String text;
                while ((text = br.readLine()) != null) {
                    s.append(text).append('\n');
                }
            }
        }
        this.name = (i = (n = f.getName()).lastIndexOf(46)) < 0 ? n : n.substring(0, i);
        this.text(s.append('\n').toString());
        return this;
    }

    public Parser<T> readFrom(InputStream is) throws IOException {
        String text;
        ParserException.ASSERT(is != null, "Parser stream is null");
        StringBuilder s = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((text = br.readLine()) != null) {
            s.append(text).append('\n');
        }
        this.text(s.append('\n').toString());
        return this;
    }

    public FilePointer end() {
        return this.end;
    }

    public Parser<T> pre(Runnable pre) {
        this.pre = pre;
        return this;
    }

    public Parser<T> piece(PieceSupplier supplier) {
        return this.piece((c, ptr) -> true, supplier);
    }

    public Parser<T> piece(PiecePredicate check, PieceSupplier supplier) {
        ParserException.ASSERT(supplier != null, "Parser piece supplier is null");
        this.pieces.add(new ParsePiece(check, supplier));
        return this;
    }

    public Parser<T> pieceFinish(Consumer<ExpressionPiece> event) {
        this.pieceFinish = event;
        return this;
    }

    public <L extends ExpressionPiece, R extends ExpressionPiece> Parser<T> group(Predicate<ExpressionPiece> left, Predicate<ExpressionPiece> right, GroupSupplier<L, R> supplier) {
        this.groups.add(new Grouper<L, R>(left, right, supplier));
        return this;
    }

    public Parser<T> pattern(String id, ParsePattern<T> pattern) {
        ParserException.ASSERT(id != null && !id.isBlank(), "Pattern ID cannot be null or empty");
        this.patterns.put(id, pattern);
        return this;
    }

    public ParsePattern<T> pattern(String id) {
        return this.patterns.get(id);
    }

    public ParsePattern<T>[] patterns() {
        return (ParsePattern[])this.patterns.values().toArray(ParsePattern[]::new);
    }

    public List<T> build() {
        return ParsePattern.match(this.buildExpressionsGrouped(), this.patterns());
    }

    public List<ExpressionPiece> buildExpressions() {
        if (this.text.isBlank()) {
            return Collections.emptyList();
        }
        if (this.pre != null) {
            this.pre.run();
        }
        LinkedList<ExpressionPiece> expressions = new LinkedList<ExpressionPiece>();
        ExpressionPiece last = null;
        FilePointer ptr = null;
        int pos = 0;
        int len = this.text.length();
        int line = 1;
        int col = 1;
        while (pos < len) {
            ptr = new FilePointer(this.name, line, col);
            char c = this.text.charAt(pos);
            if (last != null) {
                PieceResult r = last.read(c, ptr);
                if (r != PieceResult.LEAVE && r != PieceResult.REPLACE_LEAVE) {
                    ++pos;
                    if (c == '\n') {
                        ++line;
                        col = 1;
                    } else {
                        ++col;
                    }
                }
                if (r == PieceResult.REPLACE_LEAVE || r == PieceResult.REPLACE_TAKE) {
                    last = last.replace(ptr);
                    continue;
                }
                if (r == PieceResult.CONTINUE) continue;
                if (this.pieceFinish != null) {
                    this.pieceFinish.accept(last);
                }
                expressions.add(last);
                last = null;
                continue;
            }
            if (Character.isWhitespace(c)) {
                ++pos;
                if (c == '\n') {
                    ++line;
                    col = 1;
                    continue;
                }
                ++col;
                continue;
            }
            FilePointer finalPtr = ptr;
            List<ExpressionPiece> found = this.pieces.stream().filter(piece -> piece.check(c, finalPtr)).map(piece -> piece.apply(c, finalPtr)).filter(Objects::nonNull).toList();
            ParserException.ASSERT(found.size() != 0, () -> finalPtr, "Invalid symbol '" + c + "'");
            ParserException.ASSERT(found.size() == 1, () -> finalPtr, "Ambiguous symbol '" + c + "'");
            last = found.get(0);
        }
        FilePointer finalPtr = ptr;
        ParserException.ASSERT(last == null, () -> finalPtr, "Expression did not end (last: " + String.valueOf(last) + ")");
        return expressions;
    }

    public List<ExpressionPiece> buildExpressionsGrouped() {
        return this.group(this.buildExpressions());
    }

    public List<ExpressionPiece> group(List<ExpressionPiece> content) {
        LinkedList<ExpressionPiece> result = new LinkedList<ExpressionPiece>();
        if (content.size() == 0) {
            return result;
        }
        Grouper<?, ?> startGrouper = null;
        int start = 0;
        int depth = 0;
        int limit = content.size();
        for (int i = 0; i < limit; ++i) {
            ExpressionPiece current;
            block6: {
                block4: {
                    block5: {
                        current = content.get(i);
                        if (depth <= 0) break block4;
                        if (!startGrouper.start(current)) break block5;
                        ++depth;
                        break block6;
                    }
                    if (!startGrouper.end(current)) break block6;
                    ExpressionPiece startPiece = content.get(start);
                    if (--depth == 0) {
                        current = startGrouper.group(startPiece, current, this.group(content.subList(start + 1, i)));
                    }
                    break block6;
                }
                for (Grouper<?, ?> grouper : this.groups) {
                    if (!grouper.start(current)) continue;
                    startGrouper = grouper;
                    start = i;
                    ++depth;
                    break;
                }
            }
            if (depth != 0) continue;
            result.add(current);
        }
        int finalStart = start;
        ParserException.ASSERT(depth == 0, () -> ((ExpressionPiece)content.get(finalStart)).pointer(), "unbalanced group");
        return result;
    }

    private record ParsePiece(PiecePredicate check, PieceSupplier supplier) {
        public boolean check(char c, FilePointer ptr) {
            return this.check.apply(c, ptr);
        }

        public ExpressionPiece apply(char c, FilePointer ptr) {
            return this.supplier.apply(c, ptr);
        }
    }
}

