package net.diversionmc.parser.group;

import net.diversionmc.parser.expression.ExpressionPiece;
import net.diversionmc.parser.expression.GroupPiece;

import java.util.List;

/**
 * Function that creates a group from the given boundaries.
 *
 * @param <L> Group opening piece type.
 * @param <R> Group closing piece type.
 */
@FunctionalInterface
public interface GroupSupplier<L extends ExpressionPiece, R extends ExpressionPiece> {
    /**
     * Create a group from the given pieces.
     *
     * @param left    Left boundary. Make sure it matches {@link Grouper#start(ExpressionPiece)}
     * @param right   Right boundary. Make sure it matches {@link Grouper#end(ExpressionPiece)}
     * @param content Pieces inside the group.
     * @return Group made from the pieces.
     */
    GroupPiece apply(L left, R right,
                     List<ExpressionPiece> content);
}
