package net.diversionmc.parser.expression;

import net.diversionmc.parser.util.FilePointer;

import java.util.List;

/**
 * List of pieces (called group content). Does not read any characters.
 */
public abstract class GroupPiece extends ExpressionPiece {
    private final List<ExpressionPiece> content;
    
    /**
     * Construct a group piece.
     *
     * @param ptr     Creation pointer; usually left boundary position.
     * @param content Pieces inside the group.
     */
    public GroupPiece(FilePointer ptr, List<ExpressionPiece> content) {
        super(ptr);
        this.content = content;
    }
    
    public final PieceResult read(char c, FilePointer ptr) {
        return null;
    }
    
    /**
     * Get all pieces that are inside the group.
     *
     * @return Grouped pieces.
     */
    public List<ExpressionPiece> content() {
        return content;
    }
    
    public String toString() {
        return getClass().getSimpleName() + "{content=" + content + '}';
    }
}
