package net.diversionmc.parser.expression;

import net.diversionmc.parser.util.FilePointer;

import static net.diversionmc.parser.expression.PieceResult.TAKE;

public abstract class CharPiece extends ExpressionPiece {
    public final char c;
    
    public CharPiece(FilePointer ptr, char c) {
        super(ptr);
        this.c = c;
    }
    
    public PieceResult read(char c, FilePointer ptr) {
        return TAKE;
    }
    
    public String toString() {
        return c + "";
    }
}
