/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.parser.pattern;

import java.util.List;
import java.util.function.Predicate;
import net.diversionmc.parser.util.ParserException;
import net.diversionmc.parser.util.Pointable;

public record OperationSolver<V extends Pointable, O extends Pointable>(boolean rightToLeft, Predicate<O> opCheck, TriOperator<V, O> operator) {
    public void solve(List<Pointable> list) {
        int i = this.rightToLeft ? list.size() - 2 : 1;
        while (this.rightToLeft == i >= (this.rightToLeft ? 0 : list.size())) {
            Pointable op = list.get(i);
            if (this.opCheck.test(op)) {
                Pointable left = list.remove(i - 1);
                list.remove(i - 1);
                Pointable right = list.remove(i - 1);
                Pointable res = this.operator.apply(left, right, op);
                ParserException.ASSERT(res != null, op.pointer(), "operation failed");
                list.add(i - 1, res);
                if (!this.rightToLeft) {
                    i -= 2;
                }
            }
            i += this.rightToLeft ? -2 : 2;
        }
    }

    @FunctionalInterface
    public static interface TriOperator<T, O> {
        public T apply(T var1, T var2, O var3);
    }
}

