/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.parser.group;

import java.util.List;
import java.util.function.Predicate;
import net.diversionmc.parser.expression.ExpressionPiece;
import net.diversionmc.parser.group.GroupSupplier;
import net.diversionmc.parser.util.ParserException;

public record Grouper<L extends ExpressionPiece, R extends ExpressionPiece>(Predicate<ExpressionPiece> start, Predicate<ExpressionPiece> end, GroupSupplier<L, R> supplier) {
    public Grouper {
        ParserException.ASSERT(start != null, "Start group piece predicate is null");
        ParserException.ASSERT(end != null, "End group piece predicate is null");
        ParserException.ASSERT(supplier != null, "Group supplier is null");
    }

    public boolean start(ExpressionPiece toTest) {
        return this.start.test(toTest);
    }

    public boolean end(ExpressionPiece toTest) {
        return this.end.test(toTest);
    }

    public ExpressionPiece group(ExpressionPiece left, ExpressionPiece right, List<ExpressionPiece> content) {
        return this.supplier.apply(left, right, content);
    }
}

